/***************************************************************
   VOCATIONAL GUIDANCE SYSTEM
   
   This is NEW functionality added to help users find their
   purposed path based on their harmonic blueprint.
   
   Combines: Archetype + THD Phase + Scalar Modulator
   to generate specific career guidance
****************************************************************/

const VOCATIONAL_GUIDANCE = {
  // VISIONARY combinations
  'Visionary': {
    base_careers: ['Futurist', 'Strategic Consultant', 'Innovation Director', 'Trend Forecaster', 'Venture Capitalist', 'Think Tank Researcher', 'Product Visionary'],
    base_industries: ['Technology', 'Venture Capital', 'Strategic Planning', 'Innovation Labs', 'Research & Development', 'Emerging Markets'],
    phase_3_mod: {
      careers_add: ['Startup Advisor', 'Rapid Prototyper', 'Sprint Coach'],
      environment: 'Fast-paced startup environments where quick vision-to-action cycles are valued',
      style: 'You need roles that allow rapid iteration on ideas. Long planning cycles will frustrate you.'
    },
    phase_6_mod: {
      careers_add: ['Corporate Strategist', 'Product Roadmap Lead', 'Innovation Manager'],
      environment: 'Mid-size companies with clear development phases and measured growth',
      style: 'You thrive when given 6-month vision cycles to develop and refine strategic direction.'
    },
    phase_9_mod: {
      careers_add: ['Long-range Planner', 'Generational Strategist', 'Legacy Architect'],
      environment: 'Institutions focused on long-term impact: foundations, think tanks, policy institutes',
      style: 'Your visions need years to unfold. Seek roles with multi-year strategic mandates.'
    },
    scalar_action: 'You vision AND act. Seek roles where you can immediately prototype your ideas.',
    scalar_reflection: 'You vision AND analyze. Seek roles that value deep strategic thinking before action.',
    scalar_restoration: 'You vision in bursts. Seek roles that allow intense visioning followed by integration.',
    red_flags: ['Micromanagement', 'Rigid short-term KPIs', 'No budget for experimentation', 'Risk-averse culture', 'Bureaucratic approval chains'],
    alignment_signs: ['Ideas are welcomed', 'Future-orientation rewarded', 'Permission to fail forward', 'Access to decision makers', 'Resources for R&D']
  },
  
  // BUILDER combinations
  'Builder': {
    base_careers: ['Architect', 'Systems Engineer', 'Founder/CEO', 'Infrastructure Lead', 'Platform Developer', 'Operations Director', 'Process Designer'],
    base_industries: ['Construction', 'Engineering', 'Software Development', 'Manufacturing', 'Real Estate Development', 'Infrastructure'],
    phase_3_mod: {
      careers_add: ['Agile Developer', 'Rapid MVP Builder', 'Sprint Architect'],
      environment: 'Startups or innovation labs where quick builds and iterations are the norm',
      style: 'You build in sprints, not marathons. 3-week development cycles suit you perfectly.'
    },
    phase_6_mod: {
      careers_add: ['Project Manager', 'Development Lead', 'Quality Architect'],
      environment: 'Established companies with clear project phases and quality standards',
      style: 'You thrive with 6-month project cycles that allow thorough development.'
    },
    phase_9_mod: {
      careers_add: ['Enterprise Architect', 'Legacy System Designer', 'Master Builder'],
      environment: 'Large institutions building for generations: governments, foundations, major corporations',
      style: 'You build to last. Multi-year construction timelines are where you excel.'
    },
    scalar_action: 'You build with your hands as well as your mind. Physical construction suits you.',
    scalar_reflection: 'You architect before you build. Design-heavy roles suit your process.',
    scalar_restoration: 'You build in focused bursts then need recovery. Project-based work suits you.',
    red_flags: ['Constant pivoting', 'No clear specifications', 'Rushed timelines without quality', 'Purely conceptual roles', 'No tangible output'],
    alignment_signs: ['Clear deliverables', 'Respect for process', 'Quality over speed', 'Resources to build properly', 'Long-term project vision']
  },
  
  // EXPLORER combinations
  'Explorer': {
    base_careers: ['Research Scientist', 'Travel Writer', 'Investigative Journalist', 'Field Researcher', 'Pioneer/First Adopter', 'Cultural Anthropologist', 'Market Explorer'],
    base_industries: ['Research', 'Journalism', 'Travel & Adventure', 'Academic Exploration', 'New Market Development', 'Anthropology'],
    phase_3_mod: {
      careers_add: ['Rapid Researcher', 'Trend Scout', 'Quick-Turn Analyst'],
      environment: 'News organizations, trend agencies, or rapid-response research teams',
      style: 'You explore in quick bursts. Roles needing fast discovery and reporting suit you.'
    },
    phase_6_mod: {
      careers_add: ['Field Correspondent', 'Regional Expert', 'Sector Analyst'],
      environment: 'Organizations with 6-month research cycles and regional focus',
      style: 'You explore deeply within defined timeframes. Seasonal research suits you.'
    },
    phase_9_mod: {
      careers_add: ['Deep Researcher', 'Long-form Journalist', 'Expedition Leader'],
      environment: 'Academic institutions, documentary productions, or long-term expeditions',
      style: 'You need years to truly explore a subject. PhD programs and long-form work suit you.'
    },
    scalar_action: 'You explore by doing. Field work and active investigation suit you.',
    scalar_reflection: 'You explore through observation and synthesis. Research analysis suits you.',
    scalar_restoration: 'You explore intensely then integrate. Expedition-style work with breaks suits you.',
    red_flags: ['Desk-bound roles', 'Same routine daily', 'No travel budget', 'Narrow focus required', 'Discouraged curiosity'],
    alignment_signs: ['Travel opportunities', 'Research freedom', 'Discovery rewarded', 'New territory to explore', 'Curiosity valued']
  },
  
  // SAGE combinations
  'Sage': {
    base_careers: ['Professor', 'Researcher', 'Author', 'Consultant', 'Analyst', 'Philosopher', 'Knowledge Architect', 'Librarian/Archivist'],
    base_industries: ['Academia', 'Research Institutions', 'Publishing', 'Think Tanks', 'Consulting', 'Knowledge Management'],
    phase_3_mod: {
      careers_add: ['Quick-Analysis Expert', 'Real-time Commentator', 'Rapid Synthesizer'],
      environment: 'News analysis, trading floors, or rapid-response consulting',
      style: 'You synthesize wisdom quickly. Roles needing fast insight delivery suit you.'
    },
    phase_6_mod: {
      careers_add: ['Semester Professor', 'Report Author', 'Project Consultant'],
      environment: 'Traditional academia or consulting with clear project phases',
      style: 'You develop wisdom in measured cycles. Semester or project-based work suits you.'
    },
    phase_9_mod: {
      careers_add: ['Book Author', 'Distinguished Professor', 'Master Consultant'],
      environment: 'Institutions that value deep, long-term wisdom accumulation',
      style: 'You need years to develop true mastery. Tenure tracks and book contracts suit you.'
    },
    scalar_action: 'You teach by doing. Workshop facilitation and applied wisdom suit you.',
    scalar_reflection: 'You teach through deep analysis. Written work and lectures suit you.',
    scalar_restoration: 'You gather wisdom in contemplative phases. Sabbatical-friendly roles suit you.',
    red_flags: ['No time for research', 'Anti-intellectual culture', 'Surface-level work valued', 'No library/resources', 'Speed over depth'],
    alignment_signs: ['Research time protected', 'Expertise valued', 'Deep work encouraged', 'Knowledge sharing rewarded', 'Intellectual community']
  },
  
  // NURTURER combinations
  'Nurturer': {
    base_careers: ['Therapist', 'Counselor', 'HR Director', 'Nurse', 'Social Worker', 'Life Coach', 'Teacher', 'Caregiver'],
    base_industries: ['Healthcare', 'Education', 'Social Services', 'Human Resources', 'Counseling', 'Non-profit'],
    phase_3_mod: {
      careers_add: ['Crisis Counselor', 'Short-term Coach', 'Intake Specialist'],
      environment: 'Crisis centers, urgent care, or short-term intervention programs',
      style: 'You nurture in intensive bursts. Crisis work and short-term care suit you.'
    },
    phase_6_mod: {
      careers_add: ['Program Director', 'Semester Teacher', 'Care Coordinator'],
      environment: 'Schools, seasonal programs, or structured care facilities',
      style: 'You nurture through structured cycles. Academic years or program cycles suit you.'
    },
    phase_9_mod: {
      careers_add: ['Long-term Therapist', 'Foster Parent Coordinator', 'Developmental Specialist'],
      environment: 'Long-term care, developmental programs, or deep therapeutic relationships',
      style: 'You nurture through deep, long-term relationships. Multi-year care suits you.'
    },
    scalar_action: 'You nurture through active service. Hands-on care roles suit you.',
    scalar_reflection: 'You nurture through understanding. Therapy and counseling suit you.',
    scalar_restoration: 'You nurture then need to replenish. Self-care-friendly environments are essential.',
    red_flags: ['No boundaries allowed', 'Burnout culture', 'Emotional labor unvalued', 'No support systems', 'Care commodified'],
    alignment_signs: ['Boundaries respected', 'Self-care encouraged', 'Impact visible', 'Supportive team', 'Growth in those you serve']
  },
  
  // REBEL combinations
  'Rebel': {
    base_careers: ['Entrepreneur', 'Activist', 'Disruptive Innovator', 'Union Organizer', 'Reform Leader', 'Creative Director', 'Investigative Journalist'],
    base_industries: ['Startups', 'Social Justice', 'Disruption/Innovation', 'Media', 'Political Reform', 'Creative Industries'],
    phase_3_mod: {
      careers_add: ['Flash Mob Organizer', 'Viral Campaigner', 'Rapid Response Activist'],
      environment: 'Fast-moving campaigns, viral media, or rapid-response activism',
      style: 'You disrupt in quick strikes. Hit-and-move tactics suit your rhythm.'
    },
    phase_6_mod: {
      careers_add: ['Campaign Manager', 'Project Disruptor', 'Seasonal Activist'],
      environment: 'Election cycles, seasonal campaigns, or project-based reform',
      style: 'You disrupt through sustained campaigns with clear phases.'
    },
    phase_9_mod: {
      careers_add: ['Movement Builder', 'Revolutionary Leader', 'Systemic Reformer'],
      environment: 'Long-term movements, deep systemic change organizations',
      style: 'You play the long game. Generational change movements suit you.'
    },
    scalar_action: 'You rebel through direct action. Protest and physical disruption suit you.',
    scalar_reflection: 'You rebel through ideas. Writing and intellectual disruption suit you.',
    scalar_restoration: 'You rebel in bursts then need recovery. Campaign cycles with breaks suit you.',
    red_flags: ['Conformity required', 'Status quo worship', 'No room for questioning', 'Punishment for dissent', 'Innovation discouraged'],
    alignment_signs: ['Questioning welcomed', 'Change possible', 'Disruption valued', 'Freedom to challenge', 'Reform achievable']
  },
  
  // LEADER combinations
  'Leader': {
    base_careers: ['CEO', 'Executive Director', 'Military Officer', 'Political Leader', 'Department Head', 'Team Lead', 'Coach'],
    base_industries: ['Executive Leadership', 'Military', 'Government', 'Sports', 'Corporate Management', 'Non-profit Leadership'],
    phase_3_mod: {
      careers_add: ['Sprint Leader', 'Startup CEO', 'Crisis Commander'],
      environment: 'Fast-growing startups, crisis situations, or rapid-response teams',
      style: 'You lead through quick decisions and fast pivots. Agile leadership suits you.'
    },
    phase_6_mod: {
      careers_add: ['Divisional Leader', 'Seasonal Coach', 'Project Executive'],
      environment: 'Mid-size organizations with clear quarterly or seasonal cycles',
      style: 'You lead through measured phases. Clear reporting cycles suit you.'
    },
    phase_9_mod: {
      careers_add: ['Institutional Leader', 'Long-term CEO', 'Legacy Builder'],
      environment: 'Established institutions focused on long-term stability and growth',
      style: 'You lead transformations that take years. Multi-term leadership suits you.'
    },
    scalar_action: 'You lead from the front. Hands-on leadership roles suit you.',
    scalar_reflection: 'You lead through strategy. Executive planning roles suit you.',
    scalar_restoration: 'You lead in campaigns then recover. Term-limited or project leadership suits you.',
    red_flags: ['No real authority', 'Constant firefighting', 'Undermining culture', 'No resources to lead', 'Title without power'],
    alignment_signs: ['Clear authority', 'Resources available', 'Team that follows', 'Vision welcomed', 'Impact measurable']
  },
  
  // ARTIST combinations
  'Artist': {
    base_careers: ['Visual Artist', 'Musician', 'Writer', 'Designer', 'Filmmaker', 'Performer', 'Creative Director'],
    base_industries: ['Fine Arts', 'Music', 'Film/TV', 'Design', 'Publishing', 'Theater', 'Advertising'],
    phase_3_mod: {
      careers_add: ['Social Media Creator', 'Sketch Artist', 'Improvisational Performer'],
      environment: 'Fast-turnaround creative: social media, live performance, rapid design',
      style: 'You create in bursts. Quick creative cycles and live performance suit you.'
    },
    phase_6_mod: {
      careers_add: ['Album Producer', 'Seasonal Designer', 'Campaign Creative'],
      environment: 'Project-based creative with clear phases: albums, seasons, campaigns',
      style: 'You create in measured arcs. Project-based creative work suits you.'
    },
    phase_9_mod: {
      careers_add: ['Novel Author', 'Film Director', 'Master Artist'],
      environment: 'Long-form creative: novels, films, major artistic works',
      style: 'You create masterworks that take years. Patient creative processes suit you.'
    },
    scalar_action: 'You create through doing. Performance and physical art suit you.',
    scalar_reflection: 'You create through contemplation. Conceptual art and writing suit you.',
    scalar_restoration: 'You create intensely then rest. Residencies and creative retreats suit you.',
    red_flags: ['Creativity by committee', 'No creative freedom', 'Art as commodity only', 'No time for process', 'Validation-dependent culture'],
    alignment_signs: ['Creative freedom', 'Process respected', 'Originality valued', 'Time for incubation', 'Art appreciated']
  },
  
  // ALCHEMIST combinations
  'Alchemist': {
    base_careers: ['Therapist', 'Transformation Coach', 'Chemist', 'Healer', 'Change Management', 'Crisis Intervention', 'Spiritual Guide'],
    base_industries: ['Psychology', 'Chemistry', 'Transformation Coaching', 'Crisis Management', 'Spiritual Development', 'R&D'],
    phase_3_mod: {
      careers_add: ['Crisis Transformer', 'Rapid Intervention Specialist', 'Quick-Turn Coach'],
      environment: 'Crisis situations, intensive retreats, or rapid transformation programs',
      style: 'You transmute quickly. Intensive intervention and crisis work suit you.'
    },
    phase_6_mod: {
      careers_add: ['Program Alchemist', 'Seasonal Healer', 'Project Transformer'],
      environment: 'Structured transformation programs with clear phases',
      style: 'You transmute through measured processes. 6-month programs suit you.'
    },
    phase_9_mod: {
      careers_add: ['Deep Healer', 'Long-term Therapist', 'Master Alchemist'],
      environment: 'Long-term therapeutic relationships, deep healing work',
      style: 'You transmute through deep, patient processes. Multi-year healing suits you.'
    },
    scalar_action: 'You transmute through active intervention. Hands-on healing suits you.',
    scalar_reflection: 'You transmute through understanding. Analytical therapy suits you.',
    scalar_restoration: 'You transmute then need to clear yourself. Self-care essential.',
    red_flags: ['Surface fixes only', 'No depth allowed', 'Quick-fix culture', 'Transformation rushed', 'Process not valued'],
    alignment_signs: ['Depth welcomed', 'Transformation valued', 'Process respected', 'Results visible', 'Growth in clients']
  },
  
  // GUARDIAN combinations
  'Guardian': {
    base_careers: ['Security Director', 'Compliance Officer', 'Archivist', 'Quality Assurance', 'Risk Manager', 'Preservationist', 'Estate Manager'],
    base_industries: ['Security', 'Compliance', 'Archives', 'Quality Control', 'Risk Management', 'Conservation', 'Estate Management'],
    phase_3_mod: {
      careers_add: ['Rapid Response Security', 'Crisis Guard', 'Quick Audit Specialist'],
      environment: 'Crisis response, rapid audit situations, or immediate protection needs',
      style: 'You guard in quick response cycles. Emergency protection suits you.'
    },
    phase_6_mod: {
      careers_add: ['Seasonal Guard', 'Quarterly Auditor', 'Cycle Protector'],
      environment: 'Organizations with clear audit cycles and seasonal protection needs',
      style: 'You guard through regular cycles. Quarterly reviews and audits suit you.'
    },
    phase_9_mod: {
      careers_add: ['Legacy Protector', 'Institutional Guardian', 'Long-term Steward'],
      environment: 'Institutions protecting generational assets: museums, foundations, estates',
      style: 'You guard for generations. Long-term stewardship roles suit you.'
    },
    scalar_action: 'You protect through active defense. Physical security suits you.',
    scalar_reflection: 'You protect through analysis. Risk assessment and compliance suit you.',
    scalar_restoration: 'You protect then need to recharge. Shift-based security suits you.',
    red_flags: ['Security undervalued', 'Risk ignored', 'Protection resources inadequate', 'Constant breaches', 'No respect for boundaries'],
    alignment_signs: ['Security prioritized', 'Resources adequate', 'Boundaries respected', 'Prevention valued', 'Stability maintained']
  },
  
  // SEEKER combinations
  'Seeker': {
    base_careers: ['Philosopher', 'Spiritual Guide', 'Research Analyst', 'Life Coach', 'Theologian', 'Meditation Teacher', 'Meaning Consultant'],
    base_industries: ['Philosophy', 'Spirituality', 'Research', 'Coaching', 'Religion', 'Wellness', 'Personal Development'],
    phase_3_mod: {
      careers_add: ['Quick Insight Coach', 'Rapid Question Facilitator', 'Sprint Seeker'],
      environment: 'Fast-paced inquiry environments, quick coaching sessions',
      style: 'You seek answers quickly. Brief but deep sessions suit you.'
    },
    phase_6_mod: {
      careers_add: ['Semester Teacher', 'Program Guide', 'Cycle Coach'],
      environment: 'Structured seeking programs with clear phases',
      style: 'You guide seeking through measured journeys. Program-based work suits you.'
    },
    phase_9_mod: {
      careers_add: ['Spiritual Director', 'Life-long Guide', 'Master Seeker'],
      environment: 'Long-term spiritual direction, multi-year guidance relationships',
      style: 'You guide deep, long-term seeking. Ongoing spiritual direction suits you.'
    },
    scalar_action: 'You seek through experience. Pilgrimage and active seeking suit you.',
    scalar_reflection: 'You seek through contemplation. Meditation and study suit you.',
    scalar_restoration: 'You seek intensely then integrate. Retreat-based seeking suits you.',
    red_flags: ['Answers imposed', 'Questioning discouraged', 'Superficial culture', 'No space for wonder', 'Certainty required'],
    alignment_signs: ['Questions welcomed', 'Mystery honored', 'Seeking valued', 'Wonder encouraged', 'Journey respected']
  },
  
  // HEALER combinations
  'Healer': {
    base_careers: ['Doctor', 'Nurse', 'Therapist', 'Energy Healer', 'Massage Therapist', 'Counselor', 'Wellness Coach'],
    base_industries: ['Healthcare', 'Therapy', 'Wellness', 'Alternative Medicine', 'Counseling', 'Holistic Health'],
    phase_3_mod: {
      careers_add: ['Emergency Healer', 'Urgent Care', 'Crisis Therapist'],
      environment: 'Emergency rooms, urgent care, crisis intervention',
      style: 'You heal in quick, intensive bursts. Emergency and acute care suit you.'
    },
    phase_6_mod: {
      careers_add: ['Program Healer', 'Seasonal Practitioner', 'Cycle Therapist'],
      environment: 'Structured healing programs with clear phases',
      style: 'You heal through measured programs. 6-session treatment plans suit you.'
    },
    phase_9_mod: {
      careers_add: ['Long-term Therapist', 'Chronic Care Specialist', 'Master Healer'],
      environment: 'Long-term therapeutic relationships, chronic condition management',
      style: 'You heal through deep, patient relationships. Long-term care suits you.'
    },
    scalar_action: 'You heal through active intervention. Hands-on healing suits you.',
    scalar_reflection: 'You heal through understanding. Talk therapy and analysis suit you.',
    scalar_restoration: 'You heal then need to clear. Self-care is non-negotiable.',
    red_flags: ['No time for patients', 'Healing rushed', 'Self-care impossible', 'Burnout culture', 'Compassion penalized'],
    alignment_signs: ['Time for care', 'Healing valued', 'Self-care supported', 'Impact visible', 'Patient relationships possible']
  },
  
  // MYSTIC combinations
  'Mystic': {
    base_careers: ['Spiritual Teacher', 'Meditation Guide', 'Consciousness Researcher', 'Interfaith Minister', 'Contemplative', 'Wisdom Keeper', 'Sacred Space Holder'],
    base_industries: ['Spirituality', 'Meditation', 'Consciousness Studies', 'Religion', 'Retreat Centers', 'Sacred Arts'],
    phase_3_mod: {
      careers_add: ['Flash Insight Guide', 'Quick Awakening Facilitator', 'Moment Teacher'],
      environment: 'Pop-up spiritual events, quick awakening experiences',
      style: 'You transmit mystical insight in moments. Flash experiences suit you.'
    },
    phase_6_mod: {
      careers_add: ['Retreat Leader', 'Program Mystic', 'Seasonal Guide'],
      environment: 'Structured retreat programs with clear arcs',
      style: 'You guide mystical journeys through measured phases. Retreat programs suit you.'
    },
    phase_9_mod: {
      careers_add: ['Monastery Leader', 'Long-term Guru', 'Wisdom Keeper'],
      environment: 'Monastic settings, long-term spiritual communities',
      style: 'You hold mystical space over years. Contemplative communities suit you.'
    },
    scalar_action: 'You transmit through presence and action. Active spiritual leadership suits you.',
    scalar_reflection: 'You transmit through silence and being. Contemplative teaching suits you.',
    scalar_restoration: 'You hold space then need deep rest. Retreat schedules with breaks suit you.',
    red_flags: ['Spirituality commodified', 'No space for mystery', 'Materialism dominant', 'Depth rejected', 'Quick fixes demanded'],
    alignment_signs: ['Mystery honored', 'Depth valued', 'Space for silence', 'Transcendence welcomed', 'Sacred respected']
  }
};

/***************************************************************
   VOCATIONAL GUIDANCE GENERATOR
****************************************************************/
function generateVocationalGuidance(profile) {
  const arch = profile.archetypeName;
  const phase = profile.thdPhase;
  const scalar = profile.scalarMod;
  
  const guidance = VOCATIONAL_GUIDANCE[arch];
  if (!guidance) return '<p>Vocational guidance not available for this archetype.</p>';
  
  // Get phase-specific modifications
  const phaseKey = `phase_${phase}_mod`;
  const phaseMod = guidance[phaseKey] || {};
  
  // Combine base careers with phase-specific additions
  let careers = [...guidance.base_careers];
  if (phaseMod.careers_add) {
    careers = [...phaseMod.careers_add, ...careers];
  }
  
  // Get scalar-specific guidance
  const scalarKey = `scalar_${scalar.toLowerCase()}`;
  const scalarGuidance = guidance[scalarKey] || '';
  
  let html = `
    <div class="pep-voc-intro">
      <p>Based on your harmonic blueprint (${arch} + Phase ${phase} + ${scalar}), here is your vocational alignment guidance. This isn't about what you've been conditioned to do—it's about what you were <strong>designed</strong> to do from birth.</p>
    </div>
    
    <div class="pep-voc-section">
      <div class="pep-voc-label">✓ Aligned Career Paths</div>
      <div class="pep-voc-careers">${careers.slice(0, 8).join(' • ')}</div>
      <p class="pep-voc-note">These roles naturally align with your ${arch} function operating in Phase ${phase} rhythm.</p>
    </div>
    
    <div class="pep-voc-section">
      <div class="pep-voc-label">✓ Thriving Industries</div>
      <div class="pep-voc-industries">${guidance.base_industries.join(' • ')}</div>
    </div>
    
    <div class="pep-voc-section">
      <div class="pep-voc-label">✓ Ideal Work Environment</div>
      <p>${phaseMod.environment || 'An environment that honors your natural rhythm and function.'}</p>
      <p class="pep-voc-style">${phaseMod.style || ''}</p>
    </div>
    
    <div class="pep-voc-section">
      <div class="pep-voc-label">✓ Your ${scalar} Mode at Work</div>
      <p>${scalarGuidance}</p>
    </div>
    
    <div class="pep-voc-section pep-voc-redflags">
      <div class="pep-voc-label">✗ Red Flags (Misalignment Warning Signs)</div>
      <ul class="pep-voc-list">
        ${guidance.red_flags.map(f => `<li>${f}</li>`).join('')}
      </ul>
      <p class="pep-voc-warning">If you see these in a role, it will drain you regardless of compensation.</p>
    </div>
    
    <div class="pep-voc-section pep-voc-alignment">
      <div class="pep-voc-label">✓ Alignment Signs (You're in the Right Place)</div>
      <ul class="pep-voc-list">
        ${guidance.alignment_signs.map(s => `<li>${s}</li>`).join('')}
      </ul>
    </div>
    
    <div class="pep-voc-nextsteps">
      <div class="pep-voc-label">🎯 Next Steps for Alignment</div>
      <ol class="pep-voc-steps">
        <li><strong>Audit your current role:</strong> Does it align with your ${arch} function? Does the pace match your Phase ${phase} rhythm?</li>
        <li><strong>Identify friction points:</strong> Where do you feel drained? Those are likely misalignment zones.</li>
        <li><strong>Seek ${arch}-aligned opportunities:</strong> Look for roles in ${guidance.base_industries.slice(0, 3).join(', ')}.</li>
        <li><strong>Honor your ${scalar} mode:</strong> ${scalar === 'Action' ? 'Find roles with physical engagement and movement.' : scalar === 'Reflection' ? 'Find roles that allow deep thinking and analysis.' : 'Find roles that respect your need for recovery cycles.'}</li>
        <li><strong>Test in ${phase}-beat cycles:</strong> Give any new direction ${phase === 3 ? '3 weeks' : phase === 6 ? '6 weeks' : '9 weeks'} before evaluating fit.</li>
      </ol>
    </div>
    
    <div class="pep-voc-truth">
      <p><strong>The Truth:</strong> You weren't designed to fit into a job—a job should fit your design. When you're in alignment, work becomes expression. Energy flows instead of drains. Success feels natural because you're operating as you were built to operate.</p>
    </div>
  `;
  
  return html;
}

console.log('PEP Vocational Guidance System Loaded');
